/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import ibm.nways.jdm.common.Timer;
import ibm.nways.jdm.common.TimerService;
import ibm.nways.jdm.common.Wakeable;
import java.util.Hashtable;

public class Cache
implements Wakeable {
    Hashtable elements;
    Hashtable timers;
    int defaultLifespan;
    Object currentKey;

    public Cache() {
        this(100);
    }

    public Cache(int n) {
        this.elements = new Hashtable(n);
        this.timers = new Hashtable(n);
    }

    public synchronized void setDefaultLifespan(int n) {
        this.defaultLifespan = n;
    }

    public synchronized int getDefaultLifespan() {
        return this.defaultLifespan;
    }

    public synchronized void put(Object object, Object object2) {
        this.put(object, object2, this.defaultLifespan);
    }

    public synchronized void put(Object object, Object object2, int n) {
        this.remove(object);
        this.elements.put(object, object2);
        if (n != 0) {
            Timer timer = TimerService.scheduleWakeUp(n * 1000, this, object);
            this.timers.put(object, timer);
        }
    }

    public synchronized void remove(Object object) {
        this.currentKey = object;
        Timer timer = (Timer)this.timers.get(object);
        if (timer != null) {
            TimerService.cancelWakeUp(timer);
            this.elements.remove(object);
            this.timers.remove(object);
        }
        this.currentKey = null;
    }

    public synchronized Object get(Object object) {
        return this.elements.get(object);
    }

    public void wakeUp(Object object) {
        if (object == this.currentKey) {
            return;
        }
        Cache cache = this;
        synchronized (cache) {
            this.timers.remove(object);
            this.elements.remove(object);
            return;
        }
    }

    public synchronized int size() {
        return this.elements.size();
    }
}

